//   ===============================================================================================
//   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -------------------------------------------------------------------------------------------------
//   Copyright (c) 2021 by Lattice Semiconductor Corporation
// -------------------------------------------------------------------------------------------------
//
// Permission:
//
//   Lattice Semiconductor grants permission to use this code for use in synthesis for any Lattice 
//   programmable logic product.  Other use of this code, including the selling or duplication of 
//   any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL or Verilog source code is intended as a design reference which illustrates how these
//   types of functions can be implemented.  It is the user's responsibility to verify their design
//   for consistency and functionality through the use of formal verification methods.  Lattice 
//   Semiconductor provides no warranty regarding the use or functionality of this code.
//
// -------------------------------------------------------------------------------------------------
//
//                               Lattice Semiconductor Corporation
//                               5555 NE Moore Court
//                               Hillsboro, OR 97214
//                               U.S.A
//                            
//                               TEL: 1-800-Lattice (USA and Canada)
//                                    408-826-6000 (other locations)
//                            
//                               web: http://www.latticesemi.com/
//                               email: techsupport@latticesemi.com
//
// -------------------------------------------------------------------------------------------------
// Filename        : led_switch.v
// Description     : Reveal controller leds and swtich logic
// Created On      : 2021
// Revision        : Revision: 1.00 
// ------------------------------------------------------------------------------------------------

`timescale 1 ns / 1 ps

module led_switch (
  input				clk,
  input				reset,
  input		[31:0]	count,
  output reg [7:0]	leds
  );
  
  wire [7:0] switch;
  //reg [29:0] count;
  
  /*always@(posedge clk or negedge reset) begin
  	if (!reset) begin
  		count <= 0;
  	end
  	else begin
  		if (switch == 8'h55) begin
  			count <= count + 1;
  		end
  		else if (switch == 8'hAA) begin
  		count <= count - 1;
  		end
  	end
  end
 */ 
  always@(posedge clk or negedge reset) begin
  	if (!reset) begin
  		leds <= 0;
  	end
  	else begin
  		//if (count <= 16'hA5A5) begin
  		//	leds <= 8'hA5;
  		//end
  		//else begin
  			leds <=  count[7:0] ;
  		//end
  	end
  end
  
endmodule